# Volume 4 Discrete Gauge & Wilson‑Loop Simulation

This repository implements a toy 4×4 lattice gauge theory simulation used in
Volume 4 of the Absolute Relativity programme.  It has been adapted here
to integrate with the `ar-operator-core` and `vol4‑flip‑count‑simulator`
repositories.  Running the pipeline will:

1. Build a 4×4 lattice with periodic boundary conditions.
2. Load or generate a kernel (for demonstration a vector of ones is used if
   none is provided).
3. Read the per‑link flip counts from the flip‑count simulator.
4. Compute the gauge potential Aₘᵤ, exponentiate to obtain link variables Uₘᵤ,
   measure Wilson loops of sizes 1×1–3×3, and produce CSVs and plots.

The script `run_simulation.py` orchestrates the entire workflow in a single
command.  Adjust `config.yaml` to change the gauge coupling, pivot parameters,
lattice size and loop sizes.  Set `flip_counts_path` to the path produced by
the flip‑count simulator and, optionally, `kernel_path` to a precomputed
kernel.  Outputs (including `Amu.npy`, `Umu.npy`, Wilson loop CSVs and PNGs)
are written into the `data/` and `results/` directories.

## Integration & one‑step run

The various paths defined in `config.yaml`—namely `data_dir`,
`results_dir`, `flip_counts_path` and `kernel_path`—are resolved relative
to the location of the configuration file.  This means you can use
relative values such as

```yaml
flip_counts_path: ../vol4-flip-count-simulator/data/flip_counts.npy
```

in the integrated workspace and the pipeline will correctly locate the
generated flip counts.  All outputs (including `Amu.npy`, `Umu.npy`,
Wilson loop CSVs and plots) are written into the `data/` and `results/`
directories within this repository.

At the top level of the integrated workspace a convenience script
`bootstrap_and_run.sh` is provided.  Running this wrapper will invoke
the flip‑count simulator followed by the Wilson‑loop pipeline:

```bash
bash bootstrap_and_run.sh
```

It assumes that the three repositories (``ar-operator-core``,
``vol4-flip-count-simulator`` and ``vol4-discrete-gauge-wilson-loop``) live
side‑by‑side in the same directory.  The wrapper does not set up conda
environments; instead it relies on Python packages (`numpy`,
`pyyaml`, `scipy`, `matplotlib`, `pandas`) being available in the current
interpreter.  If these packages are not installed you can install them
globally or within a virtual environment using ``pip install numpy
pyyaml pandas matplotlib scipy``.  The flip‑count generator will
discover ``ar-operator-core`` via ``sys.path`` so no editable install is
required.
